 ; Ŀ
 ;   Change text or attribute values to upper, lower, or mixed case.       
 ;   Copyright 1992, 1996, 1998, 2001, 2004, 2005 by Rocket Software Ltd.  
 ;   Look for a key marked "Caps Lock".                                    
 ;   Uct: uppercase a single text line or attribute.                       
 ;   Lc: lowercase a single text line or attribute.                        
 ;   Ic: initial capitalise single text line or attribute.                 
 ;   Uc: uppercase all selected text and attributes in selected blocks.    
 ;   Fcase: initial capitalise all selected text.                          
 ; 

 ; Ŀ
 ;   Fcase.                                                                
 ;   Has to be recursive - each cycle can only consider strings which the  
 ;   previous cycle has already split, else one can capitalise and the     
 ;   next will convert back to lower case.                                 
 ;   The alternative is to lower case everything and afterwards add caps   
 ;   but never remove them.                                                
 ;   No: recursion allows one to chop the string up and consider each      
 ;   substring, otherwise can only onsider individual characters in        
 ;   relation to the nearest separator character.                          
 ; 
 (DEFUN C:FCASE (/ ss num enam entt sub prlist nustra str)
  (prompt "Select text: ")
  (setq ss (ssget '((-4 . "<or") (0 . "text") (0 . "attdef") (-4 . "or>"))))
  (setq num 0)
  (while (and ss (setq enam (ssname ss num)))
         (setq num (1+ num))
         (setq entt (entget enam))
         (if (= (cdr (assoc 0 entt)) "TEXT")
             (setq asoc 1)
             (setq asoc 3))
         (setq str (cdr (setq asoc1 (assoc asoc entt))))
         (setq str (fdash (list " " "-" "/") str))
         (entmod (subst (cons asoc str) asoc1 entt)))
 (princ))

 ; Ŀ
 ;   Uct - upper case a single line - also does attributes.                
 ; 
 (DEFUN C:UCT ()
  (uct "U")
 (princ))

 ; Ŀ
 ;   Lc - lower case a single line - also does attributes.                 
 ; 
 (DEFUN C:LC ()
  (uct "L")
 (princ))

 ; Ŀ
 ;   Ic - initial case a single line - also does attributes.               
 ; 
 (DEFUN C:IC ()
  (uct "I")
 (princ))

 ; Ŀ
 ;   Hug - string capitaliser.  Takes one argument, a string, and returns  
 ;   a list: the string with the first letter changed to upper case and    
 ;   T if this changed the string, () if not.                              
 ; 
 (DEFUN HUG (exstr / nustr)
  (setq nustr (strcat (strcase (substr exstr 1 1))
                      (strcase (substr exstr 2) t)))
 (list nustr (if (= exstr nustr) () t)))
 ; Ŀ
 ;   Hug - end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Fdash - split a string at any character in a list,         
 ;   capitalise each resulting substring, reassemble the string.           
 ;   Also watches for certain special cases.                               
 ;   Arguments: Astr: the string to process.                               
 ;              Chra: the list of separator characters.                    
 ;   Recursive.                                                            
 ; 
 (DEFUN FDASH (chra astr / sub prlist nustra nump)
  (if (and astr 
           (car chra)
           (> (length (setq prlist (splat (car chra) astr))) 0))
      (progn
           (setq nustra "")
           (while (setq sub (car prlist))
                  (setq prlist (cdr prlist))
                  (setq sub (strcase sub t))
                  (cond ((= (substr sub 1 1) "(")               ; balance: )
                         (setq sub (strcat "(" (car (hug (substr sub 2)))))) ;)
                        ((or (and (> (setq nump (sonar "." sub t)) 0)
                                  (/= (substr sub (strlen sub)) "."))
                             (> nump 1))
                         (setq sub (strcase sub)))
                        ((member sub '("vsat" "mds" "vavcu"))
                         (setq sub (strcase sub)))
                        (T (setq sub (car (hug sub)))))
                  (setq sub (fdash (cdr chra) sub))             ; recurse
                  (setq nustra (strcat nustra (car chra) sub)))
           (if (= (substr nustra 1 1) (car chra))
               (setq nustra (substr nustra 2))))
      (setq nustra astr))
 nustra)
 ; Ŀ
 ;   Fdash.                                                                
 ; 

 ; Ŀ
 ;   Sonar - see if a string contains a substring.                         
 ;   Arguments:  Loc, the substring.                                       
 ;               Txt, the string.                                          
 ;               Cas, if this is non-nil then the search                   
 ;                                is non-case-sensitive.                   
 ;   Returns the number of occurrences of the substring.                   
 ; 
 (DEFUN SONAR (loc txt cas / chflg ln sta st)
  (setq chflg 0)
  (if cas 
      (progn
           (setq loc (strcase loc t))
           (setq txt (strcase txt t))))
  (setq ln (strlen loc))
  (setq sta 1)
  (while (= ln (strlen (setq st (substr txt sta ln))))
         (if (= st loc) (setq chflg (1+ chflg)))
         (setq sta (1+ sta)))
 chflg)
 ; Ŀ
 ;   Sonar end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Splat - divide a text string into a list of substrings.    
 ;   Arguments: Sepchr, the field separator character.                     
 ;              Linn, the text string.                                     
 ;   Returns a list of field values, removes leading and trailing spaces.  
 ; 
 (DEFUN SPLAT (sepchr linn / len pos name1 strlst)
  (while (/= (strlen linn) 0)
         (while (and (= (substr linn 1 1) " ")
                     (/= (strlen linn) 0))
                (setq linn (substr linn 2)))
         (while (= (substr linn (setq len (strlen linn))) " ")
                (setq linn (substr linn 1 (1- len))))
         (setq pos 1)
         (setq len (strlen linn))
         (while (and (/= (substr linn pos 1) sepchr)
                     (>= len pos))
                (setq pos (1+ pos)))
         (setq name1 (substr linn 1 (1- pos)))
         (while (= (substr name1 (setq len (strlen linn))) " ")
                (setq name1 (substr name1 1 (1- len))))
         (setq linn (substr linn (1+ pos)))
         (setq strlst (append strlst (list name1))))
  (if (null strlst) (setq strlst (list "")))
  strlst)
 ; Ŀ
 ;   Splat end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Uct - re-case a single line - also does attributes.        
 ;   Arguments: Casa - L = convert to lowercase.                           
 ;                     U = convert to uppercase.                           
 ;                     I = initial capitals.                               
 ; 
 (DEFUN UCT (casa / snapp *error* nent enam entt str typ outer cc)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
  (defun *error* (shk)
   (if (/= shk "Function cancelled") (write-line shk))
   (if snapp (setvar "snapmode" snapp))
  (princ))
 ; Ŀ
 ;   Get a textlike entity/subentity.                                      
 ; 
  (setq enam (car (setq nent (nentsel "Select something textlike: "))))
  (setq typ (cdr (assoc 0 (setq entt (entget enam)))))
  (if (or (= "TEXT" typ) (= "MTEXT" typ) (= "ATTDEF" typ) (= "ATTRIB" typ))
      (progn
           (setq outer (car (reverse (car (reverse nent)))))
           (setq str (cdr (assoc 1 entt)))
           (cond ((= casa "L")
                  (setq cc (strcase str t)))
                 ((= casa "U")
                  (setq cc (strcase str)))
                 ((= casa "I")
                  (setq cc (fdash (list " " "-" "/") str))))
           (entmod (subst (cons 1 cc) (assoc 1 entt) entt))
           (entupd enam)
           (if (= (type outer) 'ENAME) (entupd outer))))
 (princ))
 ; Ŀ
 ;   Subroutine Uct end.                                                   
 ; 

 ; Ŀ
 ;   Uc.                                                                   
 ; 
 (defun C:UC (/ ss nn1 nn zz cc)
  (setvar "cmdecho" 0)
  (command "undo" "m")
  (write-line "Select text/blocks to convert to upper case: ")
  (setq ss (ssget))
  (setq num 0)
  (while (setq nn1 (ssname ss num))
         (setq num (1+ num))
         (setq typ (cdr (assoc 0 (setq nn (entget nn1)))))
         (cond ((or (= typ "TEXT") (= typ "MTEXT"))        ; Is entity text?
                (setq zz (cdr (assoc 1 nn)))        ; get text string
                (setq cc (strcase zz))              ; capitalise it
                (entmod (subst (cons 1 cc) (cons 1 zz) nn)))
               ((and (= typ "INSERT") (assoc 66 nn))
                (setq nsav nn1)
                (while (/= "SEQEND" (cdr (assoc 0 (setq nn (entget (setq nn1
                                                            (entnext nn1)))))))
                       (setq zz (cdr (assoc 1 nn)))        ; get text string
                       (setq cc (strcase zz))              ; capitalise it
                       (entmod (subst (cons 1 cc) (cons 1 zz) nn)))
                (entupd nsav))))
 (princ))